//Listing 13.4. Przykad hierarchii dziedziczenia dla klas Account
#include <iostream>
using namespace std;

class Account { // klasa bazowa hierarchii
protected:
  double balance;

public:
  Account(double initBalance = 0)
  { balance = initBalance; }

  double getBal()
  { return balance; } // wsplna dla obu rachunkw

  void withdraw(double amount) // wsplna dla obu rachunkw
  { if (balance > amount)
      balance -= amount; }

  void deposit(double amount)
  { balance += amount; }
} ;

class CheckingAccount : public Account { // pierwsza klasa pochodna
  double fee;

public:
  CheckingAccount(double initBalance)
  { balance = initBalance; fee = 0.2; } // jedynie dla rachunkw rozliczeniowych

  void withdraw(double amount)
  { if (balance > amount)
      balance = balance - amount - fee; } // bezwarunkowe obcienie transakcji
} ;

class SavingsAccount : public Account { // druga klasa pochodna
  double rate;

public:
  SavingsAccount(double initBalance)
  { balance = initBalance; rate = 6.0; } // rachunek oszczdnociowy

  void payInterest() // nieodpowiednie dla rachunku rozliczeniowego
  { balance += balance * rate / 365 / 100; }
} ;

int main()
{
  Account a(1000); // obiekt klasy bazowej
  CheckingAccount a1(1000); // obiekt klasy pochodnej
  SavingsAccount a2(1000); // obiekt klasy pochodnej
  a1.withdraw(100); // metoda klasy pochodnej
  a2.deposit(100); // metoda klasy bazowej
  a1.deposit(200); // metoda klasy bazowej
  a2.withdraw(200); // metoda klasy bazowej
  a2.payInterest(); // metoda klasy pochodnej
  a.deposit(300); // metoda klasy bazowej
  a.withdraw(100); // metoda klasy bazowej
  //a.payInterest(); // bd skadni
  //a1.payInterest(); // bd skadni
  cout << " Kocowe stany kont\n obiekt rachunku: "
  << a.getBal()<<endl;
  cout << " obiekt rachunku rozliczeniowego: " << a1.getBal() << endl;
  cout << " obiekt rachunku oszczdnociowego: " << a2.getBal() << endl;
  return 0;
}
